<?php
session_start();
if (isset($_SESSION['username']) && !empty($_SESSION['username'])) {
    header('Location: /dashboard.php');
    exit;
}
    ?>
<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Login | RTP CMS</title>
    <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/auth.css" rel="stylesheet">
</head>

<body>
    <div class="wrapper">
        <div class="auth-content">
            <div class="card">
                <div class="card-body text-center">
                    <div class="mb-4">
                        <img class="brand" src="assets/images/logo.png" alt="RTP logo">
                    </div>
                    <h6 class="mb-4 text-muted">Login to your account</h6>
                    <form action="" method="">
                        <div class="mb-3 text-start">
                            <label for="text" class="form-label">User</label>
                            <input type="text" class="form-control" name="username" placeholder="User Name" required>
                        </div>
                        <div class="mb-3 text-start">
                            <label for="password" class="form-label">Password</label>
                            <input type="password" class="form-control" name="password" placeholder="Password" required>
                        </div>
                        <div class="mb-3 text-start">
                            <div class="form-check">
                                <input class="form-check-input" name="remember" type="checkbox" value="" id="check1">
                                <label class="form-check-label" for="check1">
                                    Remember me on this device
                                </label>
                            </div>
                        </div>
                        <button class="btn btn-primary shadow-2 mb-4">Login</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script src="assets/vendor/jquery/jquery.min.js"></script>
    <script src="assets/vendor/bootstrap/js/bootstrap.min.js"></script>
    <script>
        jQuery(document).ready(function () {
            $('form').submit(function (e) {
                e.preventDefault()
                var tipe = 'login'
                var username = $("input[name=username]").val()
                var userpassword = $("input[name=password]").val()
                $.ajax({
                    url: 'ajax.php',
                    type: 'POST',
                    dataType: 'json',
                    data: { tipe: tipe, username: username, userpassword: userpassword },
                    success: function (response) {
                        console.log(response)
                        window.location.href = '/dashboard.php'
                    },
                    error: function (err) {
                        alert(err.responseJSON.message)
                    }
                })
            })
        })
    </script>
</body>

</html>